<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Roadway Setup Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis závislostí koridoru pro řazení v Excel</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads/RoadwayDesigner">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Kritické řízení bodů koridoru pro řazení v Excelu</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Roadway Designer Data -->
                            <!-- <xsl:for-each select="RoadwayDesigner"> -->
                                <table class="margin" cellpadding="2">
                                    <tbody>
                                        <tr>
                                            <th align="left" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@fileName"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
								<table class="margin" colspan="4" width="75%">
									<thead style="display:table-header-group">
									   <tr>
											<th  lang="en" align="left">Koridor</th>
											<th  lang="en" align="left">Řízení bodů - Reference koridoru</th>
											<th  lang="en" align="left">Ořezání koridoru - Reference koridoru</th>
											<th  lang="en" align="left">Zástupné cíle - Reference koridoru</th>
										</tr>
									</thead>
									<xsl:for-each select="Corridor">
									 <xsl:sort select="@name" order="ascending" data-type="text" />
									 <xsl:variable name="CorridorName" select="@name"/> 
                                        <tr>
                                            <td colspan="4">						
                                                    <xsl:choose>
                                                        <xsl:when test="HVControl">
															<xsl:for-each select="HVControl">
																<xsl:if test="@controlType = 'CorridorPoint'">
																	<tr>
																	<td  colspan="1" align="left"><xsl:value-of select="$CorridorName"/></td>
																	<td  colspan="1" align="left"><xsl:value-of select="@controlParentName"/></td>
																	</tr>
																</xsl:if>
                                                            </xsl:for-each>
														
															
                                                        </xsl:when>
                                                    </xsl:choose>
													<xsl:choose>
															<xsl:when test="ClippingOption">
																<xsl:for-each select="ClippingOption">
																	<tr>
																		<td  colspan="1" align="left"><xsl:value-of select="$CorridorName"/></td>
																		<td>&#xa0;</td>
																		<td  colspan="1" align="left"><xsl:value-of select="@clippingCorridor"/></td>
																		<td>&#xa0;</td>																		
																	</tr>
																</xsl:for-each>		
															</xsl:when>
													</xsl:choose>
													<xsl:choose>
													<xsl:when test="TargetAlias">
																<xsl:for-each select="TargetAlias">
																		<xsl:for-each select="Alias">
																			<tr>
																				<td  colspan="1" align="left"><xsl:value-of select="$CorridorName"/></td>
																				<td>&#xa0;</td>
																				<td>&#xa0;</td>
																				<td  colspan="1" align="left"><xsl:value-of select="@name"/></td>
																			</tr>
																		</xsl:for-each>
																</xsl:for-each>		
															</xsl:when>
													</xsl:choose>
                                            </td>
                                        </tr>
                                      </xsl:for-each>								
                                </table>
                        </xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte otevřít soubor návrhu koridoru výběrem <em>Soubor &gt; Otevřít</em> v menu <em>Průzkumník výpisů</em>
				a zadat <em>Typ souboru</em> a <em>Návrh cesty(*.ird)</em>.
            </p>
            <p class="normal1" lang="en">
                Vyexportujte výsledek do Excelu. Importujte koridory nejdříve ve druhém sloupci.  
				Koridory v prvním sloupci mají za cíl body v koridorech ve druhém sloupci.
			</p>
			<p class="normal1" lang="en">		
				Dále setřiďte třetí sloupec. Importujte tyto pře dprováděním koridorů v prvním sloupci.  
				To jsou koridory, které jsou ořezány koridory v prvním sloupci.
			</p>
			<p class="normal1" lang="en">				
				Koridory v posledním sloupci by měly být importovány také před prováděním. 
			</p>
			<p class="normal1" lang="en">
				<em> Poznámka:</em>  Jakmile byl koridor naimportován, nelze jej znovu importovat, protože je ve více jak v jednom sloupci!				
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
